/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects;

import java.util.Arrays;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.util.collections.WeightedCollection;

public enum Gem {
    AGATE(true),
    AMETHYST(true),
    BERYL(true),
    DIAMOND(false),
    EMERALD(true),
    GARNET(true),
    JADE(true),
    JASPER(true),
    OPAL(true),
    RUBY(true),
    SAPPHIRE(true),
    TOPAZ(true),
    TOURMALINE(true);

    private static final Gem[] RANDOM_DROP_GEMS;
    private final boolean canDrop;

    public static Gem getRandomDropGem(Random random) {
        return RANDOM_DROP_GEMS[random.nextInt(RANDOM_DROP_GEMS.length)];
    }

    private Gem(boolean canDrop) {
        this.canDrop = canDrop;
    }

    static {
        RANDOM_DROP_GEMS = (Gem[])Arrays.stream(Gem.values()).filter(x -> x.canDrop).toArray(Gem[]::new);
    }

    public static enum Grade {
        CHIPPED(16),
        FLAWED(8),
        NORMAL(4),
        FLAWLESS(2),
        EXQUISITE(1);

        private static final Grade[] VALUES;
        private static final WeightedCollection<Grade> GRADE_ODDS;
        private final double dropWeight;

        @Nonnull
        public static Grade randomGrade(Random random) {
            return GRADE_ODDS.getRandomEntry(random);
        }

        @Nullable
        public static Grade valueOf(int index) {
            return index >= 0 && index < VALUES.length ? VALUES[index] : null;
        }

        private Grade(int dropWeight) {
            this.dropWeight = dropWeight;
        }

        static {
            VALUES = Grade.values();
            GRADE_ODDS = new WeightedCollection<Grade>(Arrays.stream(VALUES).collect(Collectors.toMap(k -> k, v -> v.dropWeight)));
        }
    }
}

